#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//IFOSaMod01.fsh   by  Dave_Hoskins   
//https://www.shadertoy.com/view/4ddyR8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// It's full of stars...
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// https://www.shadertoy.com/view/4ddyR8
// By David Hoskins.

//#define SEEIN2D 
#define outCol col
/* bool clipTime(float t)
{
   return (t >5.0 && t < 11. || t > 20. && t < 24.);
}
*/

vec3 get2Dplanes(vec2 uv, vec2 p)
{

	float f  = 1., g =f;    
	for( int i = 0; i < 25; i++) 
	{
		float d = dot(uv,uv);
		uv = (vec2( uv.x, -uv.y ) / d) + p; 
		uv.x =  abs(uv.x);
		f = max( f, (dot(uv-p,uv*.5 -p) ));
		g = min( g, sin(dot(uv+p,uv+p))+1.);
	}
	f = abs(-log(f/8.)/3.5);
	g = abs(-log(g/5.)/5.3);
    g *= g;
	vec3 col = vec3(min(vec3(g, g*f, f), 1.0));
    col *= col;

    //  Fade in...
    return max(vec3(col-smoothstep(4.0, 0.0, iTime)), 0.0);
    
}

// Design function...
vec2 choose(float i)
{
    float g = i*2.12;
    vec2 p;
    
	p.x = -.2+sin(g * .3)*sin(g * .17) * 4. + sin(g * .3);
	p.y = (1.0-cos(g * .632))*sin(g * .131)*1.2-cos(g * .3);

	return p;    
}

vec3 starPlane(vec2 uv)
{


	vec3 col, col2;
    uv*= .25;

    float i = floor(uv.y);
    uv.y 	= fract(uv.y);
    vec2 p = choose(i);
    
    col = get2Dplanes(uv*2., p);
    p = choose(i-1.);
   	col2 = get2Dplanes(uv*2.+vec2(0,2), p);
    col = mix (col2, col, uv.y);
    return col;
}    
#define cor fragCoord
//void mainImage( out vec4 fragColor, in vec2 cor )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 cor )
{
    vec3 col = vec3(0);
/*    vec3 outCol = vec3(0.0);
#ifdef SEEIN2D
    vec2 uv = ((-iResolution.x+2.0 * cor.xy) / iResolution.y);
	outCol = starPlane(uv+vec2(0.0,iTime));

#else
    
   if (clipTime(iTime))
    {
        outCol = texelFetch(texture0, ivec2(cor), 0).xyz;
    }else
    {
 */   
    // Sub-sampling...
    for (float ax = 0.0; ax < 1.0; ax+=.5)
    {
    for (float ay = 0.0; ay < 1.0; ay+=.5)
    {
        vec2 uv = ((-iResolution.xy+2.0 * (cor + vec2(ax, ay))) / iResolution.y);

        vec3 dir = normalize(vec3(uv, 1.8-dot(uv,uv)*.25));
            if (iTime < 10.) dir.xy = dir.yx;
        
        // Mirror the horizon, shifted a little bit to remove some horizon aliasing...
        float f = abs(dir.y);
        
        float d = .25/f;
        uv = vec2(0, iTime*6.) + dir.xz* d;

        // Two distinct images for upper and lower...
        if (dir.y < 0.)
            col = starPlane(uv-2.3);
        else
            col = starPlane(uv+3.3);

        col += col;
        if (uv.y < -iTime+4.) col = vec3(0);
        col *= smoothstep(0.0, .025, abs(dir.y));
        col *= smoothstep(1.75, .5, (abs(dir.y)+abs(dir.x)));
        
        outCol += col;
    }
    }
           outCol /= 4.0;
//    }
	               

// #endif

    fragColor = vec4((outCol),1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

